<?php 
session_start();

include("../../../sql_connect.php");
include("functions.php");

$user_data = check_login($dbc);

function build_url($params = []) {
    $base_url = "codex.php";
    $query = array_merge($_GET, $params); // Merge new params with existing ones
    return $base_url . '?' . http_build_query($query);
}

$equip_id = isset($_GET['equip_id']) ? (int)$_GET['equip_id'] : 0;

if ($equip_id > 0) {
    $query = "
        SELECT w.*, u.*
        FROM warframes w
        LEFT JOIN users u ON w.CREATOR = u.USERNAME
        WHERE w.ID = $equip_id
        LIMIT 1
    ";
    $result = mysqli_query($dbc, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        // Now $row has all warframe data (prefixed with `w.` if needed)
        // and user data (from `users` table)
        // Use $row['USERNAME'], $row['EMAIL'], etc. as needed
    } else {
        echo "No warframe found for ID $equip_id.";
    }
} else {
    echo "Invalid or missing equip_id in URL.";
}


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'], $_POST['post_id'])) {
    $action = $_POST['action'];
    $post_id = (int)$_POST['post_id'];

    if ($action === 'like') {
        $stmt = $pdo->prepare("UPDATE warframes SET LIKES = LIKES + 1 WHERE ID = ?");
        $stmt->execute([$post_id]);
    } elseif ($action === 'dislike') {
        $stmt = $pdo->prepare("UPDATE warframes SET DISLIKES = DISLIKES + 1 WHERE ID = ?");
        $stmt->execute([$post_id]);
    } elseif ($action === 'delete' && $user_data['ADMIN_LEVEL'] > 1) {
        $stmt = $pdo->prepare("DELETE FROM warframes WHERE ID = ?");
        $stmt->execute([$post_id]);
    }

    header("Location: " . $_SERVER['REQUEST_URI']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<?php require("assets/includes/head.html") ?>
</head>
<title>New Build - Warpon Prime</title>
        <?php include("assets/includes/header.php"); ?>

        <form class="buildPlate" method="post">
            
            <img src="<?php echo $row['IMAGE_LINK'] ?>" alt="<?php echo $row['NAME'] ?>" class="newBuildImg">
            <div class="buildTitle">
                <h1 class="warpTitle"><?php echo $row['NAME'] ?></h1>
                <p class="newBuildDesc">
                    <?php echo $row['DESCRIPTION']; ?>
                </p>
            </div>

            <div class="newBuildStats">

                <!-- Abilities -->

                <div class="abilityModDesc">
                    <h4 class="newBuildStatDesc">Strength</h4>
                    <h4 class="newBuildStatDesc">Duration</h4>
                    <h4 class="newBuildStatDesc">Efficiency</h4>
                    <h4 class="newBuildStatDesc">Range</h4>
                </div>

                <div class="abilityModAns">
                    <h4 class="newBuildStatAns"><?php echo $row['STRENGTH'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['DURATION'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['EFFICIENCY'] ?>%</h4>
                    <h4 class="newBuildStatAns"><?php echo $row['RANGE'] ?>%</h4>
                </div>

                <!-- Stats -->

                <div class="statModDesc">
                    <h4 class="newBuildStatDesc">Health</h4>
                    <h4 class="newBuildStatDesc">Shields</h4>
                    <h4 class="newBuildStatDesc">Armor</h4>
                    <h4 class="newBuildStatDesc">Energy</h4>
                </div>

                <div class="statModAns">
                    <h4 class="newBuildStatAns"><?php echo $row['HEALTH'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['SHIELD'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['ARMOR'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['ENERGY'] ?></h4>
                </div>

                <div class="statModDesc2">
                    <h4 class="newBuildStatDesc">Gender</h4>
                    <h4 class="newBuildStatDesc">Sprint Speed</h4>
                    <h4 class="newBuildStatDesc">Damage Reduction</h4>
                    <h4 class="newBuildStatDesc">Effective Hit Points</h4>
                </div>

                <div class="statModAns2">
                    <h4 class="newBuildStatAns"><?php echo $row['SEX'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo $row['SPRINT'] ?></h4>
                    <h4 class="newBuildStatAns"><?php echo number_format((floatval($row['ARMOR']) / (floatval($row['ARMOR']) + 300) * 100), 2); ?>%</h4>
                    <h4 class="newBuildStatAns">
                        <?php
                            $armor = floatval($row['ARMOR']);
                            $health = floatval($row['HEALTH']);
                            $shield = floatval($row['SHIELD']);

                            $armorMultiplier = ($armor / ($armor + 300)) + 1;
                            $effectiveHealth = ($armorMultiplier * $health) + ($shield * 1.5);

                            echo number_format($effectiveHealth, 2);
                        ?>
                    </h4>
                </div>

            </div>

            <div class="creatorInfo">
                <h1 class="warpTitle">Warframe Information</h1>

                <div class="creatorCard">
                    <div class="creatorMeta">
                        <span class="creatorName">Creator: <strong><?php echo $row['CREATOR'] ?></strong></span>
                        <span class="masteryRank">Mastery Rank: <strong><?php echo $user['MASTERY_RANK'] ?></strong></span>
                        <span class="creationDate">Created: <strong><?php echo $row['RELEASE_DATE'] ?></strong></span>
                    </div>

                    <div class="interactions">
                        <form method="post" action="">
                            <input type="hidden" name="action" value="like">
                            <input type="hidden" name="post_id" value="<?php echo $row['ID']; ?>">
                            <button type="submit" class="likeBtn">👍 Like (<?php echo $row['LIKES']; ?>)</button>
                        </form>

                        <form method="post" action="">
                            <input type="hidden" name="action" value="dislike">
                            <input type="hidden" name="post_id" value="<?php echo $row['ID']; ?>">
                            <button type="submit" class="dislikeBtn">👎 Dislike (<?php echo $row['DISLIKES']; ?>)</button>
                        </form>

                        <?php if ($user_data['ADMIN_LEVEL'] > 1): ?>
                        <form method="post" action="">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="post_id" value="<?php echo $row['ID']; ?>">
                            <button type="submit" class="deleteBtn">🗑️ Delete</button>
                        </form>
                        <?php endif; ?>
                    </div>

                    <div class="tags">
                        <span class="tag">Warframe</span>
                        <span class="tag">Release Order of Type: <?php echo $row['RELEASE_ORDER_OF_TYPE'] ?></span>
                        <span class="tag">Mastery Rank Requirement: <?php echo $row['MASTERY'] ?></span>
                    </div>
                </div>
            </div>
        </form>

        <?php include("assets/includes/footer.html"); ?>
    </body>
</html>